const header = document.querySelector(".site-header");
const navToggle = document.querySelector(".nav__toggle");
const mobileNav = document.querySelector(".nav__mobile");
const mobileClose = document.querySelector(".nav__mobile-close");
const mobileLinks = document.querySelectorAll(".nav__mobile a");

// Open / close mobile menu
function openMobileNav() {
  mobileNav.classList.add("nav__mobile--open");
  navToggle.classList.add("nav__toggle--open");
}

function closeMobileNav() {
  mobileNav.classList.remove("nav__mobile--open");
  navToggle.classList.remove("nav__toggle--open");
}

if (navToggle && mobileNav) {
  navToggle.addEventListener("click", () => {
    const isOpen = mobileNav.classList.contains("nav__mobile--open");
    if (isOpen) {
      closeMobileNav();
    } else {
      openMobileNav();
    }
  });
}

if (mobileClose) {
  mobileClose.addEventListener("click", closeMobileNav);
}

mobileLinks.forEach((link) => {
  link.addEventListener("click", () => {
    closeMobileNav();
  });
});

// HEADER: change style on scroll
function handleHeaderScroll() {
  if (!header) return;
  if (window.scrollY > 40) {
    header.classList.add("site-header--scrolled");
  } else {
    header.classList.remove("site-header--scrolled");
  }
}

window.addEventListener("scroll", handleHeaderScroll);
handleHeaderScroll();
